/**
  Copyright (c) 2012 Freescale Semiconductor
  
  \file       mc_base.c
  \brief      This file contains the animations
  \author     Freescale Semiconductor
  \author     Automotive Systems Solutions Engineering
  \author     IM, b06623
  \version    1.1
  \date       19/May/2009
  
  * History:  26/January/2009- Initial Version

* Copyright (c) 2008, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
   
*/

#include "common.h"
#include "..\HIL\Graphics.h"
#include "..\HIL\Display.h"
#include "..\HIL\Flib.h"
#include "..\HAL\GALLO.h"
#include "..\SERVICES\DMAHandler.h"
#include "..\HIL\FontLibrary.h"
#include "mc_parameters.h"

#include "people.h"
#include "ARIAL30.h"

//NOTE: dont use mc_base_parameters, use instead mc_input_parameters
mc_input_parameters_t mc_input_parameters = {0,0,0,0};
mc_input_parameters_t mc_input_parameters_l = {0,0,0,0};
//mc_input_parameters.wheel has the scrolling value
mc_base_parameters_t mc_base_parameters;
uint8_t wheel_previous;


uint8_t basePrint(
	Graphics_Object_t*  target,
	char* string, Font_FontType* font,int16_t xoffset, 
        uint16_t yoffset, Font_JustifyType justify, uint16_t maxWidth, uint8_t count
);

uint8_t baseUpdateText(void);

// this is for the separation line on top
extern Graphics_Object_t tabsLine_RAM;

Graphics_Object_t base_TopText_RAM =
{
    (uint32_t)NULL_PTR, 400, 30, NULL_PTR, 0, 0, GRAPHICS_T8BPP, 255, 0, 0, GRAPHICS_CODING_RAWINT,0,0
};

Graphics_Object_t base_text_RAM =
{
    (uint32_t)NULL_PTR, 316, 100, NULL_PTR, 0, 0, GRAPHICS_T8BPP, 255, 0, 0, GRAPHICS_CODING_RAWINT,0,0
};


uint8_t base_tittle[] = "Phone Book - Demo Creators";

const uint8_t* const base_names[] = {
  "Derek Beattie           ",
  "Manish Jindgar       ",
  "Puneet Arora         ",
  "Ravinder Dasila      ",

  "Davor Bogavac        ",
  "Danny McKenna        ",
  "Roger Keen           ",
  "Jesus Sanchez        ",
  "Luis Olea            ",
  "Hugo Osornio         ",
  "Alberto Carillo      ",
  "Mario Velasco        ",
  "Ioseph Martinez      ",
  "Andy McDonnald       ",
  "Calum Atkinson       ",  
  "Alasdair Robertson   ",    
};

const uint8_t* const base_line2[] = {
  "Freescale UK	        ",
  "Freescale IDC	    ",
  "Freescale IDC	    ",
  "Freescale IDC	    ",
  
  "Freescale Sweden     ",
  "Freescale UK         ",
  "Freescale USA        ",
  "Freescale Mexico     ",
  "Freescale Mexico     ",
  "Freescale Mexico     ",
  "Freescale Mexico     ",
  "Freescale Mexico     ",
  "Freescale USA        ",
  "Freescale UK         ",
  "Freescale UK         ",  
  "Freescale UK         "      
};

const uint8_t* const base_line3[] = {
  "+44 501 858 4713",
  "+91 120 854 1478",
  "+91 120 245 4564",
  "+91 120 555 6851",

  "+46 501 125 8577",
  "+44 103 551 6892",
  "+1 512 889 8573   ",
  "+52 33 3283 8974",
  "+52 33 3283 8596",
  "+52 33 3283 1472",
  "+52 33 3283 1593",
  "+52 33 3283 3468",
  "+1 512 889 9988   ",
  "+44 103 551 5855",
  "+44 103 551 4712",
  "+44 103 551 5588",  
};

void mc_base(uint32_t CurrentFrame)
{
    uint32_t relative_fr;
    uint8_t dmachnl;
    uint8_t result;
    
    if(mc_base_properties.frameLatch == 0u)
    {
        mc_base_properties.frameLatch = CurrentFrame;
    }
    relative_fr = CurrentFrame - mc_base_properties.frameLatch;
    switch(relative_fr)
    {
      
      case 0:
          
        base_TopText_RAM.address = (uint32_t)p_baseSAM;
        base_text_RAM.address = base_TopText_RAM.address + base_TopText_RAM.width*base_TopText_RAM.height;
        //if (base_text_RAM.address & 0x3F) base_text_RAM.address = (base_text_RAM.address & 0xFFFFFFC0) + 0x40;
          
        dmachnl = DMAHR_GetNextFreeChannel();          
        // if there is no free DMA channel adjust the mc frame counter to do this again 
        if (dmachnl == DMAHR_NOCHNL) mc_base_properties.frameLatch--;
        else    Graphics_BlankArea(dmachnl, &base_TopText_RAM, 0x00000000, NULL_PTR);        
      break;
      case 1:          
         result = basePrint(&base_TopText_RAM,base_tittle,(Font_FontType*)&ARIAL30_Font,0, 0, FONT_CENTER, 0, 0);                
      break;  
      case 2:
        dmachnl = DMAHR_GetNextFreeChannel();    
        if (dmachnl == DMAHR_NOCHNL) mc_base_properties.frameLatch--;
        else    Graphics_BlankArea(dmachnl, &base_text_RAM, 0x00000000, NULL_PTR);                
      break;        
      case 3:
         mc_input_parameters_l.wheel = mc_input_parameters.wheel +1; //force sync
         Display_InitLayer(BASE_LINE_TOP,&tabsLine_RAM, 132, 152);
         DCU_TileMode(BASE_LINE_TOP, 1, 16, 4);
         DCU_LayerSetWidth(BASE_LINE_TOP, 536);
         DCU_LayerSetHeight(BASE_LINE_TOP, 3);
         DCU_ForeGroundColor(BASE_LINE_TOP) = TABS_GREEN;
         DCU_BackGroundColor(BASE_LINE_TOP) = 0x0;
         DCU_LayerAlphaCfg(BASE_LINE_TOP) = 0;    
              
         Display_InitLayer(BASE_TXT_TOP,&base_TopText_RAM, 200, 116);
         DCU_LayerAlphaCfg(BASE_TXT_TOP) = 2;
         DCU_LayerChromaCfg(BASE_TXT_TOP) = 1;
         Display_FGColor(BASE_TXT_TOP) = 0xFFFFFFFF;
         Display_BGColor(BASE_TXT_TOP) = 0x0; 
         
         Display_InitLayer(BASE_TXT,&base_text_RAM, 180+200, 171+64);
         DCU_LayerAlphaCfg(BASE_TXT) = 2;
         DCU_LayerChromaCfg(BASE_TXT) = 1;
         Display_FGColor(BASE_TXT) = 0xFFFFFFFF;
         Display_BGColor(BASE_TXT) = 0x0;          
         
      break;
      
      default:

        if(mc_input_parameters_l.wheel != mc_input_parameters.wheel)
        {
          Display_InitLayer(BASE_CENTER,people_GObjectArray[mc_input_parameters.wheel%people_ARRAYSIZE],220, 171);
          DCU_LayerAlpha(BASE_CENTER) = 0x11;
          DCU_LayerAlphaCfg(BASE_CENTER) = 2;
          
          //update text
          if(0 == baseUpdateText())
		  {
			mc_input_parameters_l.wheel = mc_input_parameters.wheel;
		  }
        }
        
        if(DCU_LayerAlpha(BASE_CENTER) != 0xff)
        {
            DCU_LayerAlpha(BASE_CENTER) += 0x11;  
        }
        
        
      break;
    }
    
}


int wait = 1;
void basePrintLine1(void)
{
  wait = 0;
}

uint8_t baseUpdateText(void)
{
  uint8_t dmachnl;
  uint8_t idx;
  uint8_t *ptr;
  uint8_t error = 0;
  //there are three lines of text that need update
  //first, clear the area
  //dmachnl = DMAHR_GetNextFreeChannel();          
  //wait = 1;
  //Graphics_BlankArea(dmachnl, &base_text_RAM, 0x00000000, basePrintLine1);
  //DMA_BWC( dmachnl ) = 3; 
  //DMA_Start(dmachnl);
  //while(wait){;}
    //now print three lines (TODO: optimize to be done in daisy chain without waiting)
  idx =mc_input_parameters.wheel;
  error += basePrint(&base_text_RAM,(uint8_t *)base_names[idx%people_ARRAYSIZE],(Font_FontType*)&ARIAL30_Font,0, 0, FONT_LEFT, 0, 0);      
  error += basePrint(&base_text_RAM,(uint8_t*)base_line2[idx%people_ARRAYSIZE],(Font_FontType*)&ARIAL30_Font,0, 32, FONT_LEFT, 0, 0);      
  error += basePrint(&base_text_RAM,(uint8_t*)base_line3[idx%people_ARRAYSIZE],(Font_FontType*)&ARIAL30_Font,0, 64, FONT_LEFT, 0, 0);      

  return error;
}

int basePrintwaitvar=1;
void basePrintwait(void)
{
  basePrintwaitvar = 0;    
}
uint8_t basePrint(
	Graphics_Object_t*  target,
	char* string, Font_FontType* font,int16_t xoffset, 
        uint16_t yoffset, Font_JustifyType justify, uint16_t maxWidth, uint8_t count
)
{
uint8_t dmachnl;
uint32_t i, length;
Font_ErrorType error;

        // if count is 0 this is a NULL terminated string and we need to calc the count 
        if (count == 0){
          for(i=0;i<100;i++) 
          {
            if(string[i] == 0) {count = i; break;}
          }
          if(i==100)    return 1;  // there was no NULL termination
        }
        // in case we want to limit the output width, if = 0 we don't
        if (maxWidth){
          count++;
          length = maxWidth + 1;
          while (length > maxWidth) {
            count--;  
            length = Font_StringWidth((void *) string, count, font, FONT_ASCII, FONT_DMA);
          }
        }
        

		basePrintwaitvar = 1;
		dmachnl = DMAHR_GetNextFreeChannel();
		error = Font_Print(dmachnl, target,(void *)string , count, font, FONT_ASCII,
						   FONT_FREERUN, FONT_HORIZONTAL, justify, basePrintwait, xoffset,yoffset);

		if(error == FONT_ERROR_OK){
			while(basePrintwaitvar) {;}
			return 0;
		}
		else {
			return 1;
		}
          
}

void mc_base_Dispose()
{
  DCU_LayerDisable(BASE_CENTER);
  DCU_LayerDisable(BASE_TXT_TOP);
  DCU_LayerDisable(BASE_TXT);
  DCU_LayerDisable(BASE_LINE_TOP);
  
}

void mc_base_Refresh()
{

}
